#ifndef MONITOR_DATA_HANDLER_H
#define MONITOR_DATA_HANDLER_H

/*!
  \file
  \brief j^f[^Ǘ

  \author Satofumi KAMIMURA

  $Id: MonitorDataHandler.h 439 2009-01-03 05:01:55Z satofumi $
*/

#include "MonitorModeManager.h"
#include "DetectOS.h"
#include <string>

#ifdef MSC
#define snprintf _snprintf
#endif


namespace qrk
{

  /*!
    \brief j^f[^ǗNX

    f[^tH[}bǵAQs\
    - Ps: ^CX^v, f[^oCg
    - Qs: f[^

    PsڂɂāA# ȍ~̓RgƂ݂Ȃ
  */
  class MonitorDataHandler
  {
    MonitorDataHandler(void);
    MonitorDataHandler(const MonitorDataHandler& rhs);
    MonitorDataHandler& operator = (const MonitorDataHandler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit MonitorDataHandler(std::string file,
                                MonitorModeManager::MonitorMode mode);
    ~MonitorDataHandler(void);

    int fetch(char* data, int size, const char* comment = NULL);

    /*!
      \attention s镶f[^́AȂ
    */
    int fetch(std::string& data, const char* comment = NULL);
    int fetch(bool& data, const char* comment = NULL);
    int fetch(int& data, const char* comment = NULL);
    int fetch(unsigned int& data, const char* comment = NULL);
    int fetch(short& data, const char* comment = NULL);
    int fetch(long& data, const char* comment = NULL);
  };
}

#endif /* !MONITOR_DATA_HANDLER_H */
