#ifndef GRID_TYPES_H
#define GRID_TYPES_H

/*!
  \file
  \brief Wň^`

  Wñf[^^Ǘ

  \author Satofumi KAMIMURA

  $Id: GridTypes.h 439 2009-01-03 05:01:55Z satofumi $
*/

namespace qrk {

  /*!
    \brief Qʒu
  */
  template<class T> class Grid
  {
  public:
    T x;                        //!< X ʒu
    T y;                        //!< Y ʒu


    Grid(void) : x(0), y(0)
    {
    }


    // !!! = 0 ̑pBMovingAverage  = 0 ̑Ă邽
    // !!! ̃\bh́A폜
    Grid(T value) : x(value), y(value)
    {
    }


    Grid(const Grid& rhs) : x(rhs.x), y(rhs.y)
    {
    }


    Grid(T x_, T y_) : x(x_), y(y_)
    {
    }


    Grid<T>& operator = (const Grid<T>& rhs)
    {
      this->x = rhs.x;
      this->y = rhs.y;

      return *this;
    }


    Grid<T>& operator += (const Grid<T>& rhs)
    {
      this->x += rhs.x;
      this->y += rhs.y;

      return *this;
    }


    const Grid<T> operator + (const Grid<T>& rhs) const
    {
      return Grid<T>(*this) += rhs;
    }


    Grid<T>& operator -= (const Grid<T>& rhs)
    {
      this->x -= rhs.x;
      this->y -= rhs.y;

      return *this;
    }


    const Grid<T> operator - (const Grid<T>& rhs) const
    {
      return Grid<T>(*this) -= rhs;
    }


    Grid<T>& operator *= (const T& rhs)
    {
      this->x *= rhs;
      this->y *= rhs;

      return *this;
    }


    Grid<T>& operator /= (const T& rhs)
    {
      this->x /= rhs;
      this->y /= rhs;

      return *this;
    }


    Grid<T> operator * (const T& rhs) const
    {
      return Grid<T>(*this) *= rhs;
    }


    friend const Grid<T> operator * (const T& lhs, const Grid<T>& rhs)
    {
      return Grid<T>(rhs) *= lhs;
    }


    Grid<T> operator / (const T& rhs) const
    {
      return Grid<T>(*this) /= rhs;
    }


    bool operator == (T& rhs)
    {
      return ((this->x == rhs.x) && (this->y == rhs.y));
    }

    bool operator != (T& rhs)
    {
      return ! (*this == rhs);
    }
  };


  /*!
    \brief Rʒu
  */
  template<class T> class Grid3D
  {
  public:
    T x;                        //!< X ʒu
    T y;                        //!< Y ʒu
    T z;                        //!< Z ʒu


    Grid3D(void) : x(0), y(0), z(0)
    {
    }


    Grid3D(const Grid3D& rhs) : x(rhs.x), y(rhs.y), z(rhs.z)
    {
    }


    Grid3D(T x_, T y_, T z_) : x(x_), y(y_), z(z_)
    {
    }


    Grid3D& operator = (const Grid3D& rhs)
    {
      this->x = rhs.x;
      this->y = rhs.y;
      this->z = rhs.z;

      return *this;
    }
  };
}

#endif /* !GRID_TYPES_H */
