#ifndef COORDINATE_H
#define COORDINATE_H

/*!
  \file
  \brief Wn̐

  \author Satofumi KAMIMURA

  $Id: Coordinate.h 515 2009-01-24 23:28:26Z satofumi $

  \todo ʒuXV邽߂̃\bhǉ
*/

#include "PositionTypes.h"
#include <vector>
#include <memory>


namespace qrk
{

  /*!
    \brief Wn̐
  */
  class Coordinate
  {
    Coordinate(const Coordinate& rhs);
    Coordinate& operator = (const Coordinate& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  protected:
    void updatePointPosition(Position<long>& position,
                             const Position<long>& offset,
                             bool invert = false) const;

  public:
    Coordinate(void);

    //! parent  NULL ̂ƂAoffset w͖
    Coordinate(Coordinate* parent, const qrk::Position<long>& offset);
    virtual ~Coordinate(void);

    Coordinate* parent(void);
    const std::vector<Coordinate*> children(void);

    void addChild(Coordinate* child);
    void addChild(Coordinate* child, const qrk::Position<long>& offset);
    void addChildToModule(Coordinate* child);
    void addChildToModule(Coordinate* child, const qrk::Position<long>& offset);

    // w肳ꂽqWň_ʒuAWn̂ǂɔzuĂ邩Ԃ
    qrk::Position<long> offset(const Coordinate* child) const;

    /*!
      \brief ʒu

      w肵WnɂʒuԂ

      \param[in] coordinate Wn

      \return ʒu
    */
    virtual qrk::Position<long> position(Coordinate* coordinate = NULL)
    {
      return originPosition(coordinate);
    }

    //! IuWFNǧ_AwWn̂ǂɂ̂Ԃ
    qrk::Position<long> originPosition(Coordinate* coordinate = NULL);

    //! IuWFNg̎w_AwWn̂ǂɂ̂Ԃ
    qrk::Position<long> pointPosition(Coordinate* coordinate,
                                      const qrk::Position<long>& position);
  };
}

#endif /* !COORDINATE_H */
