#ifndef ANGLE_TYPES_H
#define ANGLE_TYPES_H

/*!
  \file
  \brief px̌^Ǘ

  \author Satofumi KAMIMURA

  $Id: AngleTypes.h 508 2009-01-23 05:29:45Z satofumi $
*/


namespace qrk
{
  /*!
    \brief px̌^Ǘ
  */
  class Angle
  {
    friend Angle rad(double radian);
    friend Angle deg(int degree);

  private:
    double radian_angle_;

  public:
    Angle(void);
    Angle(const Angle& rhs);
    Angle& operator = (const Angle& rhs);
    Angle& operator += (const Angle& rhs);
    const Angle operator + (const Angle& rhs) const;
    Angle& operator -= (const Angle& rhs);
    const Angle operator - (const Angle& rhs) const;
    Angle& operator *= (const double rhs);
    Angle operator * (const double rhs) const;
    friend const Angle operator * (const double lhs, const Angle& rhs);

    int to_deg(void) const;
    double to_rad(void) const;
  };

  extern Angle rad(double radian);
  extern Angle deg(int degree);
}

#endif /* !ANGLE_TYPES_H */
