#ifndef C_SERIAL_CTRL_H
#define C_SERIAL_CTRL_H

/*!
  \file
  \brief VAʐM

  Serial Communication Interface 

  \author Satofumi KAMIMURA

  $Id: serial_ctrl.h 143 2008-08-05 18:39:57Z satofumi $
*/

#include "serial_t.h"


/*!
  \brief ڑ

  \param[in,out] serial VA̍\
  \param[in] device ڑfoCX
  \param[in] baudrate ڑ{[[g

  \retval 0 
  \retval < 0 G[
*/
extern int serial_connect(serial_t *serial, const char *device, long baudrate);


/*!
  \brief ؒf

  \param[in,out] serial VA̍\
*/
extern void serial_disconnect(serial_t *serial);


/*!
  \brief ڑԂ

  \param[in,out] serial VA̍\

  \retval 1 ڑ
  \retval 0 ؒf
*/
extern int serial_isConnected(serial_t *serial);


/*!
  \brief {[[g̕ύX

  \param[in,out] serial VA̍\
  \param[in] baudrate {[[g

  \retval 0 
  \retval < 0 G[
*/
extern int serial_setBaudrate(serial_t *serial, long baudrate);


/*!
  \brief M

  \param[in,out] serial VA̍\
  \param[in] data Mf[^
  \param[in] data_size MTCY

  \retval >= 0 MTCY
  \retval < 0 G[
*/
extern int serial_send(serial_t *serial, const char *data, int data_size);


/*!
  \brief M

  \param[in,out] serial VA̍\
  \param[in] data Mf[^i[obt@
  \param[in] data_size_max Mobt@̍őTCY
  \param[in] timeout ^CAEg [msec]

  \retval >= 0 MTCY
  \retval < 0 G[
*/
extern int serial_recv(serial_t *serial,
                       char *data, int data_size_max, int timeout);


/*!
  \brief MP߂

  \param[in,out] serial VA̍\
  \param[in] ch ߂P

  \attention ǂ݂s킸ɁAAď߂Ă͂ȂȂ
*/
extern void serial_ungetc(serial_t *serial, char ch);


#endif /* !C_SERIAL_CTRL_H */
