#ifndef URG_VIEWER_WINDOW_H
#define URG_VIEWER_WINDOW_H

/*!
  \file
  \brief URG Viewer Sample

  \author Satofumi KAMIMURA

  $Id: UrgViewerWindow.h 666 2009-03-25 23:41:10Z satofumi $
*/

#include "ui_UrgViewerWindowForm.h"
#include <memory>

namespace qrk
{
  class CaptureSettings;
}


/*!
  \brief URG データ表示ツール用ウィンドウ
*/
class UrgViewerWindow : public QMainWindow, private Ui::UrgViewerWindowForm
{
  Q_OBJECT;

  UrgViewerWindow(const UrgViewerWindow& rhs);
  UrgViewerWindow& operator = (const UrgViewerWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void rescanPressed(void);
  void connectPressed(bool connection, const std::string& device);
  void connectDevice(bool);
  void captureHandler(void);
  void initializeView(void);
  void updateStatusBar(bool active, long x_mm, long y_mm);
  void updateScansInterval(int msec);
  void aboutApplication(void);
  void autoPlay(void);
  void zoomSmaller(void);
  void zoomLarger(void);
  void closeEvent(QCloseEvent* event);
  void showCaptureSettingWidget(void);
  void receiveCaptureSettings(const qrk::CaptureSettings& settings);
  void receiveReconnectRequest(void);
  void showLengthViewWidget(void);
  void receiveLengthViewRequest(void);
  void receiveWidgetClose(const std::string& widget_name);
  void receiveDrawLine(const std::vector<int>& indexes);

public:
  UrgViewerWindow(int argc, char *argv[]);
  ~UrgViewerWindow(void);

signals:
  void reconnectCompleted(void);
};

#endif /* !URG_VIEWER_WINDOW_H */
