#ifndef RANGE_VIEW_WIDGET_H
#define RANGE_VIEW_WIDGET_H

/*!
  \file
  \brief 範囲を 2D 表示するウィジット

  \author Satofumi KAMIMURA

  $Id: RangeViewWidget.h 666 2009-03-25 23:41:10Z satofumi $
*/

#include <QWidget>
#include <memory>

namespace qrk
{
  class RangeSensorParameter;
}
class CaptureSettingWidget;


/*!
  \brief データ取得範囲の描画ウィジット
*/
class RangeViewWidget : public QWidget
{
  Q_OBJECT;

  RangeViewWidget(const RangeViewWidget& rhs);
  RangeViewWidget& operator = (const RangeViewWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void paintEvent(QPaintEvent* event);

protected slots:
  void isRangeChanged(int first_index, int last_index);

public:
  RangeViewWidget(CaptureSettingWidget* parent = 0);
  ~RangeViewWidget(void);

  void setParameter(const qrk::RangeSensorParameter& parameter);
};

#endif /* !RANGE_VIEW_WIDGET_H */
