#ifndef CONNECT_THREAD_H
#define CONNECT_THREAD_H

/*!
  \file
  \brief 再生時の接続用スレッド

  \author Satofumi KAMIMURA

  $Id: ConnectThread.h 666 2009-03-25 23:41:10Z satofumi $
*/

#include <QThread>
#include <memory>

namespace qrk
{
  class RangeSensor;
}


/*!
  \brief 接続用スレッドクラス
*/
class ConnectThread : public QThread
{
  Q_OBJECT;

  ConnectThread(void);
  ConnectThread(const ConnectThread& rhs);
  ConnectThread& operator = (const ConnectThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void run(void);

public:
  ConnectThread(qrk::RangeSensor& sensor);
  ~ConnectThread(void);

  void setConnectSettings(const std::string& device, long baudrate);

signals:
  void connected(bool connected);
};

#endif /* !CONNECT_THREAD_H */
