/*!
  \file
  \brief Wii を用いた URG データの三次元描画

  \author Satofumi KAMIMURA

  $Id: UrgScanner.cpp 786 2009-05-05 11:55:48Z satofumi $
*/

#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include "UrgScannerWindow.h"


//! main
int main(int argc, char *argv[]) {

  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("UrgScanner_" + locale);
  app.installTranslator(&translator);

  // アプリケーションの起動
  UrgScannerWindow window;
  window.show();
  return app.exec();
}
