#ifndef URG_DATA_DRAW_H
#define URG_DATA_DRAW_H

/*!
  \file
  \brief Wii 姿勢を考慮した URG データの描画を行う

  \author Satofumi KAMIMURA

  $Id: UrgDataDraw.h 786 2009-05-05 11:55:48Z satofumi $

  \todo !!! Wii の入力については、構造体で渡すようにする
*/

#include <QGLWidget>
#include "Point3d.h"

namespace qrk {
  class RangeSensor;
}


/*!
  \brief URG データの描画クラス
*/
class UrgDataDraw : public QGLWidget {
  Q_OBJECT;

  UrgDataDraw(const UrgDataDraw& rhs);
  UrgDataDraw& operator = (const UrgDataDraw& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event);

  QSize minimumSizeHint(void) const;

public slots:
  //! H 型センサ
  void setTypeH(bool checked);

  //! 前面のみ測定
  void setFrontOnly(bool front_only);

  //! 拡大率の変更
  void magnifyChanged(int value);

  //! 視点の初期化
  void resetView(void);

public:
  /*!
    \brief コンストラクタ

    \param[in] parent 親ウィジット
  */
  UrgDataDraw(QWidget* parent = 0);
  ~UrgDataDraw(void);

  void redraw(qrk::RangeSensor& sensor,
              qrk::Point3d<int>& wii_rotate, bool record, bool no_plot);

  void clearCaptureData(void);

  void loadVrml(const std::string& fileName);
  void saveVrml(const std::string& fileName);

  void setIntensityMode(bool on);
};

#endif /* !URG_DATA_DRAW_H */
