/*!
  \file
  \brief SCIP データを応答単位で読み出す

  \author Satofumi KAMIMURA

  $Id: ScipDataReader.cpp 784 2009-05-05 11:47:37Z satofumi $
*/

#include "ScipDataReader.h"
#include <fstream>

using namespace std;


struct ScipDataReader::pImpl
{
  string log_file_;
  ifstream fin_;


  pImpl(const string& log_file) : log_file_(log_file)
  {
    fin_.open(log_file_.c_str());
  }
};


ScipDataReader::ScipDataReader(const string& log_file)
  : pimpl(new pImpl(log_file))
{
}


ScipDataReader::~ScipDataReader(void)
{
}


bool ScipDataReader::isEmpty(void)
{
  if (! pimpl->fin_.is_open()) {
    return true;
  }
  return (pimpl->fin_.eof()) ? true : false;
}


bool ScipDataReader::readReplyLines(vector<string>& line_block)
{
  line_block.clear();
  string line;
  while (getline(pimpl->fin_, line) && (! line.empty())) {
    //fprintf(stderr, "%s\n", line.c_str());
    line_block.push_back(line);
  }

  return (! line_block.empty());
}
