/*!
  \file
  \brief Lua への geometry モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindGeometry.cpp 717 2009-04-07 14:50:59Z satofumi $
*/

#include "luabindGeometry.h"
#include "luabindInit.h"
#include "Point.h"
#include "Rect.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindGeometry(void)
{
  lua_State* lua = luabindInit();

  module(lua)
    [
     class_<Point<long> >("Point")
     .def(constructor<long, long>())
     .def_readwrite("x", &Point<long>::x)
     .def_readwrite("y", &Point<long>::y),

     class_<Point<double> >("fPoint")
     .def(constructor<double, double>())
     .def_readwrite("x", &Point<double>::x)
     .def_readwrite("y", &Point<double>::y),

     class_<Rect<long> >("Rect")
     .def(constructor<long, long, long, long>())
     .def_readwrite("x", &Rect<long>::x)
     .def_readwrite("y", &Rect<long>::y)
     .def_readwrite("w", &Rect<long>::w)
     .def_readwrite("h", &Rect<long>::h),

     class_<Rect<double> >("fRect")
     .def(constructor<double, double, double, double>())
     .def_readwrite("x", &Rect<double>::x)
     .def_readwrite("y", &Rect<double>::y)
     .def_readwrite("w", &Rect<double>::w)
     .def_readwrite("h", &Rect<double>::h)
     ];
}
