/*!
  \file
  \brief Lua へのモジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindFlyFlapp.cpp 798 2009-05-05 23:20:05Z satofumi $
*/

#include "luabindFlyFlapp.h"
#include "luabindInit.h"
#include "InputHandler.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void luabindFlyFlapp(void)
{
  lua_State* lua = luabindInit();

  module(lua)
    [
     class_<InputHandler>("InputHandler")
     .def(constructor<>())
     .def("update", &InputHandler::update)
     .def("isQuit", &InputHandler::isQuit)
     .def("leftClicked", &InputHandler::leftClicked)
     .def("rightClicked", &InputHandler::rightClicked)
     .def("setCursorPosition", &InputHandler::setCursorPosition)
     .def("cursorPosition", &InputHandler::cursorPosition)
     ];
}

