#ifndef QRK_TEXT_INPUT_H
#define QRK_TEXT_INPUT_H

/*!
  \file
  \brief 入力文字の取得

  \author Satofumi KAMIMURA

  $Id: TextInput.h 854 2009-05-11 09:52:18Z satofumi $
*/

#include "Event.h"
#include <memory>


namespace qrk
{
  class CallbackEvent;


  /*!
    \brief 入力文字の取得
  */
  class TextInput : public Event
  {
    friend class LayerManager;

    TextInput(const Event& rhs);
    TextInput& operator = (const Event& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

    void setEventAcceptable(bool acceptable);
    void clearEvent(void);
    void checkKey(SDLKey key, Uint8 type, SDLMod mod, Uint16 unicode);
    void checkClick(Uint8 mouse_button, Uint8 type);
    void checkEnterCursor(const Point<long>& current,
                          const Point<long>& previous);
    void cursorMoved(void);

  public:
    TextInput(void);
    ~TextInput(void);

    void clear(void);
    bool empty(void) const;
    const char* text(void) const;
    bool isChanged(void) const;

    void setBackspaceEvent(CallbackEvent* event);
    void setDecideEvent(CallbackEvent* event);
  };
}

#endif /* !QRK_TEXT_INPUT_H */
