/*!
  \file
  \brief Lua の補助

  \author Satofumi KAMIMURA

  $Id: LuaHandler.cpp 918 2009-05-22 07:38:52Z satofumi $
*/

#include "LuaHandler.h"
#include "log_printf.h"
#include <sstream>
#include <string>

using namespace qrk;
using namespace std;


namespace
{
  void handleError(lua_State* lua)
  {
    string error_message = lua_tostring(lua, -1);

    log_printf("error: %s\n", error_message.c_str());
  }
}


struct LuaHandler::pImpl
{
  string error_message_;
  lua_State* lua_;
  string path_;


  pImpl(void)
    : error_message_("Not initialized."), lua_(lua_open()), path_("")
  {
    luaL_openlibs(lua_);
  }


  ~pImpl(void)
  {
    // exit() 時に lua に登録したオブジェクトが生成順に関係なく削除され、
    // Segmentation falt が起きるため、閉じないことにする
    // lua_close(lua_);
  }


  static pImpl* object(void)
  {
    static pImpl singleton_object;
    return &singleton_object;
  }
};


LuaHandler::LuaHandler(void) : pimpl(pImpl::object())
{
}


LuaHandler::~LuaHandler(void)
{
}


lua_State* LuaHandler::pointer(void)
{
  return pImpl::object()->lua_;
}


void LuaHandler::addPath(const char* additional_path)
{
  LuaHandler lua_handler;
  lua_handler.pimpl->path_ += string(additional_path) + ";";

  // パス設定の評価
  string lua_path = "package.path = \"" + lua_handler.pimpl->path_ + "\"";
  lua_handler.doString(lua_path.c_str());
}


int LuaHandler::doFile(const char* lua_file)
{
  lua_State* lua = LuaHandler::pointer();
  int ret = luaL_dofile(lua, lua_file);
  if (ret) {
    handleError(lua);
  }
  return ret;
}


int LuaHandler::doString(const char* lua_string)
{
  lua_State* lua = LuaHandler::pointer();
  int ret = luaL_dostring(lua, lua_string);
  if (ret) {
    handleError(lua);
  }
  return ret;
}


void LuaHandler::registerValue(const char* name, int value)
{
  lua_State* lua = LuaHandler::pointer();

  lua_pushnumber(lua, value);
  lua_setglobal(lua, name);
}
