#ifndef QRK_EVENT_UTILS_H
#define QRK_EVENT_UTILS_H

/*!
  \file
  \brief イベント定義

  \author Satofumi KAMIMURA

  $Id: EventUtils.h 762 2009-04-22 14:32:32Z satofumi $
*/

namespace qrk
{
  class CallbackEvent;


  /*!
    \brief 終了イベントの登録

    Ctrl-q, Alt-F4 の押下イベントを追加する
  */
  extern void setQuitEvent(CallbackEvent* event);


  /*!
    \brief リターンキー・イベントの登録

    Enter, テンキー Enter の押下イベントを追加する
  */
  extern void setEnterEvent(CallbackEvent* event);
}

#endif /* !QRK_EVENT_UTILS_H */
