/*!
  \file
  \brief イベント管理

n  \author Satofumi KAMIMURA

  $Id: EventManager.cpp 733 2009-04-14 22:20:15Z satofumi $
*/

#include "EventManager.h"
#include "Event.h"
#include <boost/bind.hpp>
#include <algorithm>
#include <list>

using namespace qrk;
using namespace boost;
using namespace std;


namespace
{
  typedef list<Event*> Events;
}


struct EventManager::pImpl
{
  Events events_;


  void remove(Event* event)
  {
    Events::iterator it = find(events_.begin(), events_.end(), event);
    if (it != events_.end()) {
      events_.erase(it);
    }
  }
};


EventManager::EventManager(void) : pimpl(new pImpl)
{
}


EventManager::~EventManager(void)
{
}


void EventManager::clear(void)
{
  for_each(pimpl->events_.begin(), pimpl->events_.end(),
           bind(&Event::clearEvent, _1));
}


void EventManager::insert(Event* event)
{
  pimpl->events_.push_back(event);
}


void EventManager::remove(Event* event)
{
  pimpl->remove(event);
}


void EventManager::checkKey(SDLKey key, Uint8 type, SDLMod mod, Uint16 unicode)
{
  for_each(pimpl->events_.begin(), pimpl->events_.end(),
           bind(&Event::checkKey, _1, key, type, mod, unicode));
}


void EventManager::checkClick(Uint8 mouse_button, Uint8 type)
{
  for_each(pimpl->events_.begin(), pimpl->events_.end(),
           bind(&Event::checkClick, _1, mouse_button, type));
}


void EventManager::checkEnterCursor(const Point<long>& current,
                                    const Point<long>& previous)
{
  for_each(pimpl->events_.begin(), pimpl->events_.end(),
           bind(&Event::checkEnterCursor, _1, current, previous));
}


void EventManager::cursorMoved(void)
{
  for_each(pimpl->events_.begin(), pimpl->events_.end(),
           bind(&Event::cursorMoved, _1));
}
