#ifndef QRK_COMPONENT_H
#define QRK_COMPONENT_H

/*!
  \file
  \brief コンポーネントのインターフェース定義

  \author Satofumi KAMIMURA

  $Id: Component.h 857 2009-05-11 12:59:05Z satofumi $
*/

#include "Rect.h"
#include "Point.h"


namespace qrk
{
  /*!
    \brief コンポーネントのインターフェース定義
  */
  class Component
  {
    Point<long> position_;

  public:
    virtual ~Component(void)
    {
    }


    virtual void setPosition(const Point<long>& position)
    {
      position_ = position;
    }


    virtual Point<long> position(void) const
    {
      return position_;
    }


    virtual Rect<long> rect(void) const = 0;
    virtual void setEventAcceptable(bool acceptable) = 0;
    virtual void setAlpha(float alpha) = 0;
    virtual void draw(const Rect<long>& area) = 0;
  };
}

#endif /* !QRK_COMPONENT_H */
