/*!
  \file
  \brief 画像の取得サンプル

  \author Satofumi KAMIMURA

  $Id: captureSample.cpp 329 2008-11-03 00:02:55Z satofumi $
*/

#include "CameraCtrl.h"
#include "delay.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  CameraCtrl camera;
  if (! camera.connect()) {
    printf("CameraCtrl::connect fail.\n");
    exit(1);
  }
  camera.setCaptureSize(320, 240);

  for (int i = 0; i < 100; ++i) {
    delay(1000);

    enum { BufferSize = 80 };
    char buffer[BufferSize];
    snprintf(buffer, BufferSize, "capture%d.jpg", i);

    if (! camera.capture(buffer)) {
      fprintf(stderr, "capture fail.\n");
      break;
    }
    printf("capture: %s\n", buffer);
  }
  return 0;
}
