#ifndef QRK_CAMERA_CTRL_H
#define QRK_CAMERA_CTRL_H

/*!
  \file
  \brief カメラ制御

  \author Satofumi KAMIMURA

  $Id: CameraCtrl.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief カメラ制御
  */
  class CameraCtrl {
    CameraCtrl(const CameraCtrl& rhs);
    CameraCtrl& operator = (const CameraCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    CameraCtrl(void);
    ~CameraCtrl(void);

    const char* what(void);

    bool connect(void);
    void disconnect(void);

    void setCaptureSize(int width, int height);
    bool capture(const char* fileName = "capture.jpg");
  };
}

#endif /* !QRK_CAMERA_CTRL_H */
