/*!
  \file
  \brief CycleTimer の動作サンプル

  \author Satofumi KAMIMURA

  $Id: cycleWait.cpp 757 2009-04-21 12:38:42Z satofumi $
*/

#include "CycleTimer.h"
#include "getTicks.h"
#include "delay.h"
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  CycleTimer cycle_timer;

  int first_ticks = getTicks();
  enum { Turns = 100 };
  for (int i = 0; i < Turns; ++i) {
    cout << getTicks() << endl;
    delay(cycle_timer.waitMsec());
  }
  int last_ticks = getTicks();

  cout << (1000.0 * Turns / (last_ticks - first_ticks)) << " [fps]" << endl;

  return 0;
}
