/*!
  \file
  \brief std::string 文字列への変換

  \author Satofumi KAMIMURA

  $Id: ConvertStdStringPath.cpp 785 2009-05-05 11:54:11Z satofumi $
*/

#include <QString>
#include <QLocale>
#include <QTextCodec>
#include <QSysInfo>
#include "ConvertStdStringPath.h"

using namespace std;


namespace
{
  string updateCodecType(const string& codec_name)
  {
    string codec_type = codec_name;

#ifdef Q_WS_WIN
    QSysInfo::WinVersion version = QSysInfo::windowsVersion();
    if (codec_type.empty() &&
        ((version == QSysInfo::WV_XP) || (version == QSysInfo::WV_2000))) {
      codec_type = "Shift-JIS";
    }
#endif

    // !!! Linux だと、EUC-JP か？

    return codec_type;
  }
}


const string qrk::toStdStringPath(const QString& text,
                                       const string& codec_name)
{
  if (QLocale::system().name().compare("ja_JP")) {
    // 日本語ロケールでなければ、戻る
    return text.toStdString();
  }

  string codec_type = updateCodecType(codec_name);
  if (! codec_type.empty()) {
    // 文字コードの変換
    QTextCodec* codec = QTextCodec::codecForName(codec_type.c_str());
    if (codec && codec->canEncode(text)) {
      return QString(codec->fromUnicode(text)).toStdString();
    }
  }
  return text.toStdString();
}


const QString qrk::toQtStringPath(const string& text,
                                  const string& codec_name)
{
  if (QLocale::system().name().compare("ja_JP")) {
    // 日本語ロケールでなければ、戻る
    return text.c_str();
  }

  string codec_type = updateCodecType(codec_name);
  if (! codec_type.empty()) {
    // 文字コードの変換
    QTextCodec* codec = QTextCodec::codecForName(codec_type.c_str());
    if (codec) {
      return codec->toUnicode(text.c_str());
    }
  }
  return text.c_str();
}
