/*!
  \file
  \brief ログの記録関数

  \author Satofumi KAMIMURA

  $Id: log_printf.cpp 761 2009-04-22 12:16:01Z satofumi $
*/

#include "log_printf.h"
#include "DetectOS.h"
#include <string>
#include <cstdio>
#include <cstdarg>

using namespace std;


namespace
{
  string log_file_ = "error_log.txt";
}


int qrk::log_printf(const char *format, ...)
{
  static FILE* fd = NULL;
  if (fd == NULL) {
    fd = fopen(log_file_.c_str(), "w");
    if (fd == NULL) {
      return -1;
    }
  }

  va_list ap;

  // 標準エラー出力
  va_start(ap, format);
  vfprintf(stderr, format, ap);
  va_end(ap);

  // ファイル出力
  va_start(ap, format);
  int ret = vfprintf(fd, format, ap);
  va_end(ap);

  // fclose() する機会がないので、内容を書き出しておく
  fflush(fd);

  return ret;
}


void qrk::log_setName(const char* file_name)
{
  log_file_ = file_name;
}
