#ifndef QRK_SLAVE_LAYER_H
#define QRK_SLAVE_LAYER_H

/*!
  \file
  \brief リモート描画 (クライアント側)

  \author Satofumi KAMIMURA

  $Id: SlaveLayer.h 914 2009-05-20 22:16:35Z satofumi $
*/

#include "LayerInterface.h"
#include <memory>


namespace qrk
{
  class SlaveLayer : public LayerInterface
  {
    class Component;


    SlaveLayer(const SlaveLayer& rhs);
    SlaveLayer& operator = (SlaveLayer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    SlaveLayer(void);
    ~SlaveLayer(void);

    void setAlpha(float alpha);
    void draw(void);

    void clear(void);
    void push_front(Component* component);
    void push_back(Component* component);
    void remove(Component* component);
  };
}

#endif /* !QRK_SLAVE_LAYER_H */
