/*!
  \example findUrgPortsSample.cpp

  \brief FindUrgPorts の動作サンプル

  \author Satofumi KAMIMURA

  $Id: findUrgPortsSample.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "UrgUsbCom.h"
#include "FindComPorts.h"
#include <SDL.h>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[]) {

  UrgUsbCom urg_usb;
  FindComPorts urg_finder(&urg_usb);
  vector<string> ports = urg_finder.find();

  // 見付かったポートを全て出力する
  printf("ports: %u\n", ports.size());
  for (vector<string>::iterator it = ports.begin();
       it != ports.end(); ++it) {
    printf("%s\n", it->c_str());
  }

  return 0;
}
