/*!
  \example scip_20_md.cpp

  \brief MD の使用サンプル

  \author Satofumi KAMIMURA

  $Id: scip_20_md.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "DetectOS.h"
#include "SerialCtrl.h"
#include "ConnectionUtils.h"
#include "ScipUtils.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // 適切にポート名を変更すること
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialCtrl con;
  if (! con.connect(device, 19200)) {
    printf("SerialCtrl::connect: %s\n", con.what());
    exit(1);
  }

  // SCIP2.0 の呼び出しと、応答の無視
  enum { Timeout = 200 };
  con.send("SCIP2.0\r", 8);
  skip(&con, Timeout);

  // "MD" コマンドの送信
  /*
    MD    または、MS
    0000  AMIN の値を使うべき
    0768  AMAX 以下でなければならない
    01    まとめる数
    0     フレーム間引き。X を指定すると X 周期分のデータを送らなくなる
    02    データの送信回数。00 指定で無限にデータを送り続ける
  */
  con.send("MD0000076801000\r", 16);

  // 受信データの表示
  // 最初の１周はレーザが消灯状態であるため、
  // 実際に返される応答はコマンド発行後の次の周期からになる
  enum {
    LineMax = 64 + 1 + 1,
    URG_04LX_MAX = 768,
    TryTimes = 5,
  };
  char buffer[LineMax];
  int n;
  for (int j = 0; j < TryTimes; ++j) { // データを読み出す回数
    while ((n = readline(&con, buffer, LineMax, Timeout)) > 0) {
      printf("%s\n", buffer);
    }
    printf("\n");

    // ２回分のデータ取得時に "QT" を用いてデータ取得を停止する
    if (j >= 1) {
      con.send("QT\r", 3);
    }
  }
  printf("\n");

  // データのデコード処理は、省略します
  // エコーバックとステータスコード後に、連続データが続きますが、
  // 基本は "GD" の処理と同じです。

  return 0;
}
