/*!
  \example setTimestampSample.cpp

  \brief タイムスタンプ合わせの動作サンプル

  \author Satofumi KAMIMURA

  $Id: setTimestampSample.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "mUrgCtrl.h"
#include "getTicks.h"
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  long timestamp = 0;
  vector<long> data;
  urg.capture(data, &timestamp);
  printf("timestamp: %ld\n", timestamp);

  // 現在の PC タイムスタンプと URG のタイムスタンプを同期させる
  urg.setTimestamp(getTicks());

  for (int i = 0; i < 5; ++i) {
    printf("PC : %d\t", getTicks());
    urg.capture(data, &timestamp);
    printf("URG: %ld, %d\n", timestamp, getTicks());
  }

  return 0;
}
