/*!
  \example recordRecvData.cpp

  \brief 受信データのログ記録サンプル

  \author Satofumi KAMIMURA

  $Id: recordRecvData.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "SerialCtrl.h"
#include "ConnectionUtils.h"
#include <SDL.h>

using namespace qrk;

namespace
{
  enum {
    Timeout = 1000,
    BufferSize = 80,
  };
}


int main(int argc, char *argv[])
{
  SerialCtrl con;
  if (! con.connect("/dev/usb/ttyUSB0", 115200)) {
    printf("SerialCtrl::connect: %s\n", con.what());
    exit(1);
  }

  con.send("SCIP2.0\r", 8);
  skip(&con, Timeout);

  // 連続データ取得コマンドの指示
  con.send("MS0044072502200\r", 16);

  char buffer[BufferSize];

  int count = 0;
  while (1) {
    readline(&con, buffer, BufferSize, Timeout);
    printf("%s\n", buffer);

    if (count % 100 == 0) {
      fprintf(stderr, "%d\n", count);
    }
    ++count;
  }
}
