/*!
  \file
  \brief データ通信速度の計測用プログラム

  \author Satofumi KAMIMURA

  $Id: measureCaptureSecond.cpp 907 2009-05-20 05:22:34Z satofumi $
*/

#include "UrgCtrl.h"
#include "getTicks.h"
#include "delay.h"
#include <iostream>
#include <cstdlib>
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  //const char* device = "COM3";
  //const char* device = "/dev/usb/ttyUSB0";
  const char* device = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device, 57600)) {
    cout << "UrgCtrl::connect: " << urg.what() << endl;
    exit(1);
  }

  urg.setCaptureMode(AutoCapture);

  enum { CaptureTimes = 20 };
  std::vector<long> data;

  int first_ticks = getTicks();
  int previous_ticks = first_ticks;
  for (int i = 0; i < CaptureTimes;) {
    int n = urg.capture(data);
    if (n <= 0) {
      delay(1);
      continue;
    }
    ++i;
    //cout << "n = " << n << endl;
    int ticks = getTicks();
    cout << i << " [times], " << (ticks - first_ticks) << " [msec], "
         << " (" << (ticks - previous_ticks) << ")" << endl;
    previous_ticks = ticks;
  }
  int last_ticks = getTicks();

  int total_msec = last_ticks - first_ticks;
  cout << CaptureTimes << " [scans]" << endl;
  cout << (1.0 * total_msec / CaptureTimes) << " [msec] / [scans]" << endl;

  return 0;
}
