/*!
  \example laserToggleSample.cpp

  \brief レーザ発光の制御サンプル

  \author Satofumi KAMIMURA

  $Id: laserToggleSample.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "mUrgCtrl.h"
#include <SDL.h>

using namespace qrk;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  for (int i = 0; i < 2; ++i) {
    urg.setLaserOutput(UrgCtrl::On);
    getchar();

    urg.setLaserOutput(UrgCtrl::Off);
    getchar();
  }

  return 0;
}
