/*!
  \example gd_check.cpp

  \brief GD 取得中にデータが受信できなくなる、という現象の再現用

  \author Satofumi KAMIMURA

  $Id: gd_check.cpp 778 2009-05-05 08:13:45Z satofumi $

  \attention 動作確認後、削除すること
*/

#include "mUrgCtrl.h"
#include "getTicks.h"
#include <SDL.h>
#include <cstdlib>
#include <cassert>
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0", 115200)) {
  //if (! urg.connect("COM3", 115200)) {
    cout << "UrgCtrl::connect: " << urg.what() << endl;
    exit(1);
  }

  enum {
    FirstIndex = 128,
    LastIndex = 640,
    EvaluateMinute = 30,
  };
  urg.setCaptureRange(FirstIndex, LastIndex);

  vector<long> data;
  int first_ticks = getTicks();
  int counter = 0;

  while ((getTicks() - first_ticks) < (EvaluateMinute * 60 * 1000)) {
    int n = urg.capture(data);
    assert(n == static_cast<int>(LastIndex + 1));

    ++counter;
    if ((counter % 10) == 0) {
      cerr << (counter / 10) << ", ";
    }
  }

  return 0;
}
