/*!
  \example gdCaptureSample.cpp

  \brief GD コマンドによるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdCaptureSample.cpp 883 2009-05-13 19:32:54Z satofumi $
*/

#include "mUrgCtrl.h"
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  //const char device[] = "COM4";
  //const char device[] = "/dev/ttyACM0";
  const char device[] = "/dev/usb/ttyUSB0";

  mUrgCtrl urg(argc, argv);

  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // GD コマンドで指定された回数だけスキャンを行い、出力する
  enum { CaptureTimes = 1 };
  for (int i = 0; i < CaptureTimes; ++i) {
    long timestamp = 0;
    vector<long> data;

    int n = urg.capture(data, &timestamp);

    printf("timestamp: %ld\n", timestamp);
    for (int j = 0; j < n; ++j) {
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
  }
  return 0;
}
