/*!
  \file
  \brief Win32 p URG f[^̎擾Tv

  \author Satofumi KAMIMURA

  $Id: capture_sample.cpp 881 2009-05-13 18:25:04Z satofumi $

  RpCEs@
  - Visual Studio ̏ꍇ
  - capture_sample.zip WJĂłtH_ capture_sample.sln I
  - Visual Studio NAF5 ărhƎss
  - COM |[gȂꍇ́Amain  com_port ύX邱

  - MinGW, Cygwin Ȃǂ̏ꍇ
  - % g++ capture_sample.cpp -o capture_sample
  - % ./capture_sample
  - COM |[gȂꍇ́Amain  com_port ύX邱

  \attention main()  com_port, com_baudrate ͓K؂ɕύX邱
  \attention vOgpɔQ̐ӔC͕Ȃ̂Ƃ
  \attention oO񍐂͊}܂
*/

#define _CRT_SECURE_NO_WARNINGS

#include <windows.h>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <string>

using namespace std;


// SCIP ̏o͂L^Ƃ́ARAW_OUTPUT Lɂ
//#define RAW_OUTPUT

#if defined(RAW_OUTPUT)
static FILE* Raw_fd_ = NULL;
#endif


enum {
  Timeout = 1000,
  EachTimeout = 2,
  LineLength = 16 + 64 + 1 + 1 + 1,
};

static HANDLE HCom = INVALID_HANDLE_VALUE;
static int ReadableSize = 0;
static char* ErrorMessage = "no error.";


/*!
  \brief ZT̊Ǘ
*/
typedef struct
{
  enum {
    MODL = 0,                   //!< ZT^
    DMIN,                       //!< ŏv\ [mm]
    DMAX,                       //!< őv\ [mm]
    ARES,                       //!< px\(360x̕)
    AMIN,                       //!< ŏv\l
    AMAX,                       //!< őv\l
    AFRT,                       //!< ʕl
    SCAN,                       //!< Wpx
  };
  string model;            //!< 擾 MODL 
  long distance_min;            //!< 擾 DMIN 
  long distance_max;            //!< 擾 DMAX 
  int area_total;               //!< 擾 ARES 
  int area_min;                 //!< 擾 AMIN 
  int area_max;                 //!< 擾 AMAX 
  int area_front;               //!< 擾 AFRT 
  int scan_rpm;                 //!< 擾 SCAN 

  int first;                    //!< Jnʒu
  int last;                     //!< Iʒu
  int max_size;                 //!< f[^̍őTCY
  long last_timestamp; //!< ŌɃf[^擾Ƃ̃^CX^v
} urg_state_t;


// ҋ@
static void delay(int msec)
{
  Sleep(msec);
}


// VAM
static int com_connect(const char* device, long baudrate)
{
#if defined(RAW_OUTPUT)
  Raw_fd_ = fopen("raw_output.txt", "w");
#endif

  char adjust_device[16];
  _snprintf(adjust_device, 16, "\\\\.\\%s", device);
  HCom = CreateFile(adjust_device, GENERIC_READ | GENERIC_WRITE, 0,
                     NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

  if (HCom == INVALID_HANDLE_VALUE) {
    return -1;
  }

  // {[[gݒ
  // !!! ȗ

  return true;
}


static void com_disconnect(void)
{
  if (HCom != INVALID_HANDLE_VALUE) {
    CloseHandle(HCom);
    HCom = INVALID_HANDLE_VALUE;
  }
}


static int com_changeBaudrate(long baudrate)
{
  DCB dcb;

  GetCommState(HCom, &dcb);
  dcb.BaudRate = baudrate;
  dcb.ByteSize = 8;
  dcb.Parity = NOPARITY;
  dcb.fParity = FALSE;
  dcb.StopBits = ONESTOPBIT;
  SetCommState(HCom, &dcb);

  return 0;
}


static int com_send(const char* data, int size)
{
  DWORD n;
  WriteFile(HCom, data, size, &n, NULL);
  return n;
}


static int com_recv(char* data, int max_size, int timeout)
{
  if (max_size <= 0) {
    return 0;
  }

  /* ߂P΁Ao */
  int filled = 0;

  /* vTCỸf[^M\Ȃ΁AǂݏoĕԂ */
  if (ReadableSize < max_size) {
    DWORD dwErrors;
    COMSTAT ComStat;
    ClearCommError(HCom, &dwErrors, &ComStat);
    ReadableSize = ComStat.cbInQue;
  }

  if (max_size > ReadableSize) {
    COMMTIMEOUTS pcto;
    int each_timeout = 2;

    if (timeout == 0) {
      /* ݂邾ǂݏoĕԂ */
      max_size = ReadableSize;

    } else {
      if (timeout < 0) {
	/* ^CAEg̒l[ɂƁA^C}[͓삹M҂ */
	timeout = 0;
	each_timeout = 0;
      }

      /* ^CAEgݒ */
      GetCommTimeouts(HCom, &pcto);
      pcto.ReadIntervalTimeout = timeout;
      pcto.ReadTotalTimeoutMultiplier = each_timeout;
      pcto.ReadTotalTimeoutConstant = timeout;
      SetCommTimeouts(HCom, &pcto);

      /* Xbhؑւ𑣂 */
      delay(1);
    }
  }
  DWORD n;
  ReadFile(HCom, &data[filled], (DWORD)max_size, &n, NULL);
#if defined(RAW_OUTPUT)
  if (Raw_fd_) {
    for (int i = 0; i < n; ++i) {
      fprintf(Raw_fd_, "%c", data[filled + i]);
    }
    // I^C~OȂ߁AtbVĂ܂
    fflush(Raw_fd_);
  }
#endif
  if (n > 0) {
    ReadableSize -= n;
  }

  return (n + filled);
}


// URG ɑ΂ăR}hMs
static int urg_sendTag(const char* tag)
{
  char send_message[LineLength];
  _snprintf(send_message, LineLength, "%s\n", tag);
  int send_size = (int)strlen(send_message);
  com_send(send_message, send_size);

  return send_size;
}


// URG s܂ł̃f[^ǂݏo
static int urg_readLine(char *buffer)
{
  int i;
  for (i = 0; i < LineLength -1; ++i) {
    char recv_ch;
    int n = com_recv(&recv_ch, 1, Timeout);
    if (n <= 0) {
      if (i == 0) {
        return -1;              // ^CAEg
      }
      break;
    }
    if ((recv_ch == '\r') || (recv_ch == '\n')) {
      break;
    }
    buffer[i] = recv_ch;
  }
  buffer[i] = '\0';

  return i;
}


// URG ɑ΂ăR}h𑗂A҂
static int urg_sendMessage(const char* command, int timeout, int* recv_n)
{
  int send_size = urg_sendTag(command);
  int recv_size = send_size + 2 + 1 + 2;
  char buffer[LineLength];

  int n = com_recv(buffer, recv_size, timeout);
  *recv_n = n;

  if (n < recv_size) {
    // MTCYȂꍇ
    return -1;
  }

  if (strncmp(buffer, command, send_size -1)) {
    // command vȂꍇ
    return -1;
  }

  // !!! \Ȃ΁AŃ`FbNT̐mFׂ

  // ̕A16iĕԂ
  char reply_str[3] = "00";
  reply_str[0] = buffer[send_size];
  reply_str[1] = buffer[send_size + 1];
  return strtol(reply_str, NULL, 16);
}


// {[[gύX
static int urg_changeBaudrate(long baudrate)
{
  char buffer[] = "SSxxxxxx\r";
  _snprintf(buffer, 10, "SS%06d\r", baudrate);
  int dummy = 0;
  int ret = urg_sendMessage(buffer, Timeout, &dummy);

  if ((ret == 0) || (ret == 3) || (ret == 4)) {
    return 0;
  } else {
    return -1;
  }
}


// URG p[^̓ǂݏo
static int urg_getParameters(urg_state_t* state)
{
  // p[^ǂݏoƔf
  urg_sendTag("PP");
  char buffer[LineLength];
  int line_index = 0;
  enum {
    TagReply = 0,
    DataReply,
    Other,
  };
  int line_length;
  for (; (line_length = urg_readLine(buffer)) > 0; ++line_index) {

    if (line_index == Other + urg_state_t::MODL) {
      buffer[line_length - 2] = '\0';
      state->model = &buffer[5];

    } else if (line_index == Other + urg_state_t::DMIN) {
      state->distance_min = atoi(&buffer[5]);

    } else if (line_index == Other + urg_state_t::DMAX) {
      state->distance_max = atoi(&buffer[5]);

    } else if (line_index == Other + urg_state_t::ARES) {
      state->area_total = atoi(&buffer[5]);

    } else if (line_index == Other + urg_state_t::AMIN) {
      state->area_min = atoi(&buffer[5]);
      state->first = state->area_min;

    } else if (line_index == Other + urg_state_t::AMAX) {
      state->area_max = atoi(&buffer[5]);
      state->last = state->area_max;

    } else if (line_index == Other + urg_state_t::AFRT) {
      state->area_front = atoi(&buffer[5]);

    } else if (line_index == Other + urg_state_t::SCAN) {
      state->scan_rpm = atoi(&buffer[5]);
    }
  }

  if (line_index <= Other + urg_state_t::SCAN) {
    return -1;
  }
  // Kvȃf[^TCY̌vZ
  state->max_size = state->area_max +1;

  return 0;
}


/*!
  \brief URG ւ̐ڑ

  \param state [o] ZT
  \param port [i] foCX
  \param baudrate [i] {[[g [bps]

  \retval 0 I
  \retval < 0 G[
*/
static int urg_connect(urg_state_t* state,
                       const char* port, const long baudrate)
{
  enum { BufferSize = 256 };
  static char message_buffer[BufferSize];

  if (com_connect(port, baudrate) < 0) {
    _snprintf(message_buffer, BufferSize, "Cannot connect COM device: %s", port);
    ErrorMessage = message_buffer;
    return -1;
  }

  const long try_baudrate[] = { 19200, 115200, 38400 };
  for (size_t i = 0; i < sizeof(try_baudrate)/sizeof(try_baudrate[0]); ++i) {

    // {[[gςȂAʐMł{[[gT
    if (com_changeBaudrate(try_baudrate[i])) {
      ErrorMessage = "change baudrate fail.";
      return -1;
    }

    // SCIP2.0 [hɕύX
    int recv_n = 0;
    urg_sendMessage("SCIP2.0", Timeout, &recv_n);
    if (recv_n <= 0) {
      // {[[g̈Ⴂɂ艞ȂƂ݂ȂÃ{[[g
      continue;
    }

    // w肳ꂽ{[[gƈقȂꍇAύX
    if (try_baudrate[i] != baudrate) {
      urg_changeBaudrate(baudrate);

      // ύXÂPɕύXf
      // āA PC ̃{[[gύXOɑҋ@ׂ
      delay(100);

      com_changeBaudrate(baudrate);
    }

    // p[^̓ǂݏo
    if (urg_getParameters(state) < 0) {
      ErrorMessage =
        "PP command fail.\n"
	"This COM device may be not URG, or URG firmware is too old.\n"
        "SCIP 1.1 protocol is not supported. Please update URG firmware.";
      return -1;
    }
    state->last_timestamp = 0;

    // URG ̌oɐ
    return 0;
  }

  // URG ̌oɎs
  ErrorMessage = "no urg ports.";
  return -1;
}


/*!
  \brief ؒf
*/
static void urg_disconnect(void)
{
  com_disconnect();
}


/*!
  \brief GD R}hpf[^擾

  \param state [i] ZT

  \retval 0 I
  \retval < 0 G[
*/
static int urg_captureByGD(const urg_state_t* state)
{
  char send_message[LineLength];
  _snprintf(send_message, LineLength,
            "GD%04d%04d%02d", state->first, state->last, 0);

  return urg_sendTag(send_message);
}


/*!
  \brief MD pf[^擾

  \param state [i] ZT
  \param capture_times [i] 

  \retval 0 I
  \retval < 0 G[
*/
static int urg_captureByMD(const urg_state_t* state, int capture_times)
{
  // 100 𒴂f[^擾ɑ΂ẮA񐔂 00 (擾)w肵A
  // QT or RS R}hŃf[^擾~邱
  if (capture_times >= 100) {
    capture_times = 0;
  }

  char send_message[LineLength];
  _snprintf(send_message, LineLength, "MD%04d%04d%02d%01d%02d",
            state->first, state->last, 0, 0, capture_times);

  return urg_sendTag(send_message);
}


// URG  6bit f[^fR[h
static long urg_decode(const char* data, int data_byte)
{
  long value = 0;
  for (int i = 0; i < data_byte; ++i) {
    value <<= 6;
    value &= ~0x3f;
    value |= data[i] - 0x30;
  }
  return value;
}


// URG f[^̎M
static int urg_addRecvData(const char buffer[], long data[], int* filled)
{
  static int remain_byte = 0;
  static char remain_data[3];
  const int data_byte = 3;

  const char* pre_p = buffer;
  const char* p = pre_p;

  if (remain_byte > 0) {
    memmove(&remain_data[remain_byte], buffer, data_byte - remain_byte);
    data[*filled] = urg_decode(remain_data, data_byte);
    ++(*filled);
    pre_p = &buffer[data_byte - remain_byte];
    p = pre_p;
    remain_byte = 0;
  }

  do {
    ++p;
    if ((p - pre_p) >= static_cast<int>(data_byte)) {
      data[*filled] = urg_decode(pre_p, data_byte);
      ++(*filled);
      pre_p = p;
    }
  } while (*p != '\0');
  remain_byte = (int)(p - pre_p);
  memmove(remain_data, pre_p, remain_byte);

  return 0;
}


/*!
  \brief URG f[^̎M

  f[^zɊi[Ai[f[^߂lŕԂB

  \param state [i] ZT
  \param data [o] f[^
  \param max_size [i] f[^obt@TCY

  \retval >= 0 f[^
  \retval < 0 G[
*/
static int urg_receiveData(urg_state_t* state, long data[], size_t max_size)
{
  int filled = 0;

  // first ܂ min ܂ł̗̈ 19(vL͈͊O)Ŗ߂
  for (int i = state->first -1; i >= 0; --i) {
    data[filled++] = 19;
  }

  char message_type = 'M';
  char buffer[LineLength];
  int line_length;
  for (int i = 0; (line_length = urg_readLine(buffer)) >= 0; ++i) {

    // `FbNT̊mF
    if ((i >= 6) && (line_length == 0)) {

      // f[^M̊
      for (size_t i = filled; i < max_size; ++i) {
        // f[^܂ł 19(vL͈͊O)Ŗ߂
        data[filled++] = 19;
      }
      return filled;

    } else if (i == 0) {
      // MbZ[W̍ŏ̕ŃbZ[W̔s
      if ((buffer[0] != 'M') && (buffer[0] != 'G')) {
        return -1;
      }
      message_type = buffer[0];

    } else if (! strncmp(buffer, "99b", 3)) {
      // "99b" oAȍ~u^CX^vvuf[^vƂ݂Ȃ
      i = 4;

    } else if ((i == 1) && (message_type == 'G')) {
      i = 4;

    } else if (i == 4) {
      // "99b" Œ
      if (strncmp(buffer, "99b", 3)) {
        return -1;
      }

    } else if (i == 5) {
      state->last_timestamp = urg_decode(buffer, 4);

    } else if (i >= 6) {
      // 擾f[^
      if (line_length > (64 + 1)) {
        line_length = (64 + 1);
      }
      buffer[line_length -1] = '\0';
      int ret = urg_addRecvData(buffer, data, &filled);
      if (ret < 0) {
        return ret;
      }
    }
  }
  return -1;
}


void outputData(long data[], int n, size_t total_index)
{
  char output_file[] = "data_xxxxxx.csv";
  _snprintf(output_file, sizeof(output_file), "data_%03d.csv", total_index);
  FILE* fd = fopen(output_file, "w");
  if (! fd) {
    perror("fopen");
    return;
  }

  for (int i = 0; i < n; ++i) {
    fprintf(fd, "%ld, ", data[i]);
  }
  fprintf(fd, "\n");

  fclose(fd);
}


int main(int argc, char *argv[])
{
  // COM |[gݒ
  const char* com_port = "COM7";
  const long com_baudrate = 115200;

  // URG ɐڑ
  urg_state_t urg_state;
  int ret = urg_connect(&urg_state, com_port, com_baudrate);
  if (ret < 0) {
    // G[bZ[Wo͂ďI
    printf("urg_connect: %s\n", ErrorMessage);

    // ɏIȂ߂̏BsvȂ΍폜邱
    getchar();
    exit(1);
  }

  int max_size = urg_state.max_size;
  long* data = new long [max_size];

  enum { CaptureTimes = 5 };


  //////////////////////////////////////////////////////////////////////
  // GD R}hpf[^擾
  printf("using GD command\n");

  // GD R}hł̃f[^擾̏ꍇɂ́ABM R}hł̃[U_Kv
  int recv_n = 0;
  urg_sendMessage("BM", Timeout, &recv_n);

  size_t total_index = 0;
  for (int i = 0; i < CaptureTimes; ++i) {
    urg_captureByGD(&urg_state);
    int n = urg_receiveData(&urg_state, data, max_size);
    if (n > 0) {
      printf("% 3d: front: %ld, urg_timestamp: %ld\n",
             i, data[urg_state.area_front], urg_state.last_timestamp);

      outputData(data, n, ++total_index);
    }
  }
  printf("\n");

  /////////////////////////////////////////////////////////////////////
  // MD R}hpf[^擾
  printf("using MD command\n");

  urg_captureByMD(&urg_state, CaptureTimes);
  for (int i = 0; i < CaptureTimes; ++i) {
    int n = urg_receiveData(&urg_state, data, max_size);
    if (n > 0) {
      printf("% 3d: front: %ld, urg_timestamp: %ld\n",
             i, data[urg_state.area_front], urg_state.last_timestamp);

      outputData(data, n, ++total_index);
    }
  }
  // MD R}hł̎擾ƁA[U͎

  // A100 ȏ̃f[^擾w肵ꍇɂ́A
  // urg_captureByMD() Ŗ̃f[^擾ɐݒ肳Ă̂ŁA
  // QT R}hpāAIɃf[^~s
  if (CaptureTimes >= 100) {
    int dummy;
    urg_sendMessage("QT", Timeout, &dummy);
  }

  urg_disconnect();
  delete [] data;

  printf("end.\n");

  // ɏIȂ߂̏BsvȂ΍폜邱
  getchar();
  return 0;
}
