/*!
  \example get_version_lines.c

  \brief バージョン情報の取得

  URG のバージョン文字列を取得する

  \author Satofumi KAMIMURA

  $Id: get_version_lines.c 777 2009-05-05 08:12:10Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


//! main
int main(int argc, char *argv[])
{
  enum {
    LinesMax = 5,
  };

  const char device[] = "COM4"; /* Windows での例 */
  //const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  char buffer[LinesMax][UrgLineWidth];
  char *lines[LinesMax];
  int ret;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }

  /* バージョン情報の取得 */
  for (i = 0; i < LinesMax; ++i) {
    lines[i] = buffer[i];
  }
  ret = urg_versionLines(&urg, lines, LinesMax);
  printf("urg_getVersion: %s\n", urg_error(&urg));
  if (ret < 0) {
    urg_disconnect(&urg);
    exit(1);
  }

  /* 表示 */
  for (i = 0; i < LinesMax; ++i) {
    printf("%s\n", lines[i]);
  }

  /* 切断 */
  urg_disconnect(&urg);

  return 0;
}
