/*!
  \example gd_scan.c

  \brief GD スキャンサンプル

  GD コマンドを用いて、逐次の距離データ取得を行う

  \author Satofumi KAMIMURA

  $Id: gd_scan.c 904 2009-05-19 15:01:32Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


int main(int argc, char *argv[])
{
  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */
  //const char device[] = "/dev/usb/ttyUSB0"; /* Linux での例 */

  int data_max;
  long *data;
  int timestamp;
  int ret;
  int n;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }

  /* 受信バッファの確保 */
  data_max = urg_dataMax(&urg);
  data = (long*)malloc(sizeof(long) * data_max);
  if (data == NULL) {
    perror("malloc");
    exit(1);
  }

  /* GD でのデータ要求 */
  ret = urg_requestData(&urg, URG_GD, URG_FIRST, URG_LAST);
  if (ret < 0) {
    urg_exit(&urg, "urg_requestData()");
  }

  /* 受信 */
  n = urg_receiveData(&urg, data, data_max);
  printf("# n = %d\n", n);
  if (n < 0) {
    urg_exit(&urg, "urg_receiveData()");
  }

  /* 表示 */
  timestamp = urg_recentTimestamp(&urg);
  printf("# timestamp: %d\n", timestamp);
  for (i = 0; i < n; ++i) {
    /* urg_minDistance() 以下の距離データは、無効値を表す */
    printf("%d %ld, ", i, data[i]);
  }
  printf("\n");

  urg_disconnect(&urg);
  free(data);

  return 0;
}
