/*!
  \example encode_sample.c

  \brief エンコードサンプル

  \author Satofumi KAMIMURA

  $Id: encode_sample.c 777 2009-05-05 08:12:10Z satofumi $
*/

#include <stdio.h>


static int encode(const char code[], int byte) {

  int value = 0;
  int i;

  for (i = 0; i < byte; ++i) {
    value <<= 6;
    value &= ~0x3f;
    value |= code[i] - 0x30;
  }
  return value;
}


//! main
int main(int argc, char *argv[]) {

  printf("%d\n", encode("0KDO", 4));
  printf("%d\n", encode("i=EK", 4));
  printf("%d\n", encode("00i", 3));
  printf("%d\n", encode("00k", 3));
  printf("%d\n", encode("00n", 3));
  printf("%d\n", encode("011", 3));
  printf("%d\n", encode("012", 3));

  return 0;
}
