/*!
  \file
  \brief ロックガード

  \author Satofumi KAMIMURA

  $Id: LockGuard.cpp 421 2008-12-25 13:42:56Z satofumi $
*/

#include "LockGuard.h"
#include "Lock.h"

using namespace qrk;


struct LockGuard::pImpl
{
  Lock& mutex_;


  pImpl(Lock& mutex) : mutex_(mutex)
  {
    mutex_.lock();
  }


  ~pImpl(void)
  {
    mutex_.unlock();
  }
};


LockGuard::LockGuard(Lock& mutex) : pimpl(new pImpl(mutex))
{
}


LockGuard::~LockGuard(void)
{
}
