/*!
  \example scip_20_vv.cpp

  \brief VV 応答の取得

  \author Satofumi KAMIMURA

  $Id: scip_20_vv.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "SerialCtrl.h"
#include "DetectOS.h"
#include "ConnectionUtils.h"
#include <cstdio>
#include <cstdlib>

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // 適切にポート名を変更すること
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialCtrl con;
  if (! con.connect(device, 19200)) {
    printf("SerialCtrl::connect: %s\n", con.what());
    exit(1);
  }

  // SCIP2.0 の呼び出しと、応答の無視
  enum { Timeout = 200 };
  con.send("SCIP2.0\r", 8);
  skip(&con, Timeout);

  // "VV" コマンドの発行
  con.send("VV\r", 3);

  // 受信データの表示
  enum { LineMax = 64 + 1 };
  char buffer[LineMax];
  int n;
  while ((n = readline(&con, buffer, LineMax, Timeout)) > 0) {
    printf("%s\n", buffer);
  }

  return 0;
}
