/*!
  \file
  \brief Lua への system モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindSystem.cpp 758 2009-04-21 12:45:57Z satofumi $
*/

#include "luabindSystem.h"
#include "luabindInit.h"
#include "delay.h"
#include "getTicks.h"
#include "CycleTimer.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindSystem(void)
{
  lua_State* lua = luabindInit();

  module(lua)
    [
     def("delay", &delay),
     def("getTicks", &getTicks),

     class_<CycleTimer>("CycleTimer")
     .def(constructor<>())
     .def("waitMsec", &CycleTimer::waitMsec)
     .def("reset", &CycleTimer::reset)
     .def("setStrictCycle", &CycleTimer::setStrictCycle)
     .def("setCycleFps", &CycleTimer::setCycleFps)
     .def("cycleFps", &CycleTimer::cycleFps)
     .def("setCycleMsec", &CycleTimer::setCycleMsec)
     .def("cycleMsec", &CycleTimer::cycleMsec)
     .def("toNextCycleMsec", &CycleTimer::toNextCycleMsec)
     ];
}
