#ifndef QRK_LUA_HANDLER_H
#define QRK_LUA_HANDLER_H

/*!
  \file
  \brief Lua の補助

  \author Satofumi KAMIMURA

  $Id: LuaHandler.h 803 2009-05-06 15:29:51Z satofumi $
*/

#include <lua.hpp>


namespace qrk
{
  /*!
    \brief Lua の補助クラス
  */
  class LuaHandler
  {
    LuaHandler(const LuaHandler& rhs);
    LuaHandler& operator = (const LuaHandler& rhs);

    struct pImpl;
    pImpl* pimpl;

  public:
    LuaHandler(void);
    ~LuaHandler(void);

    static lua_State* pointer(void);
    static void addPath(const char* additional_path);
    static int doFile(const char* lua_file);
    static int doString(const char* lua_string);
    static void registerValue(const char* name, int value);
  };
}

#endif /* !QRK_LUA_HANDLER_H */
