#ifndef QRK_SWITCH_SURFACE_H
#define QRK_SWITCH_SURFACE_H

/*!
  \file
  \brief 表示内容を交換できるサーフェス

  \author Satofumi KAMIMURA

  $Id: SwitchSurface.h 857 2009-05-11 12:59:05Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
  class SwitchSurface : public Surface
  {
    SwitchSurface(const SwitchSurface& rhs);
    SwitchSurface& operator = (const SwitchSurface& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    SwitchSurface(void);
    ~SwitchSurface(void);

    bool isValid(void) const;
    Rect<long> rect(void) const;
    void setAlpha(float alpha);
    float alpha(void) const;
    void draw(const Rect<long>* src, const Rect<long>* dest);

    void addSurface(Surface& surface, size_t id);
    void removeSurface(size_t id);
    void setDrawSurface(size_t id);
    size_t currentSurfaceId(void);
  };
}

#endif /* !QRK_SWITCH_SURFACE_H */
