#ifndef QRK_LABLE_H

#define QRK_LABLE_H

/*!
  \file
  \brief ラベル

  \author Satofumi KAMIMURA

  $Id: Label.h 857 2009-05-11 12:59:05Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
  class Surface;


  /*!
    \brief ラベル
  */
  class Label : public Component
  {
    Label(const Label& rhs);
    Label& operator = (Label& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit Label(Surface& surface);
    ~Label(void);

    Rect<long> rect(void) const;
    void setEventAcceptable(bool acceptable);
    void setAlpha(float alpha);
    void draw(const Rect<long>& area);
  };
}

#endif /* !QRK_LABLE_H */
