#ifndef QRK_EVENT_H
#define QRK_EVENT_H

/*!
  \file
  \brief イベント・インターフェース

  \author Satofumi KAMIMURA

  $Id: Event.h 742 2009-04-17 22:26:21Z satofumi $
*/

#include "Point.h"
#include <SDL.h>


namespace qrk
{
  /*!
    \brief イベント・インターフェース
  */
  class Event
  {
  public:
    virtual ~Event(void)
    {
    }

    virtual void setEventAcceptable(bool acceptable) = 0;
    virtual void clearEvent(void) = 0;
    virtual void checkKey(SDLKey key, Uint8 type,
                          SDLMod mod, Uint16 unicode) = 0;
    virtual void checkClick(Uint8 mouse_button, Uint8 type) = 0;
    virtual void checkEnterCursor(const Point<long>& current,
                                  const Point<long>& previous) = 0;
    virtual void cursorMoved(void) = 0;
  };
}

#endif /* !QRK_EVENT_H */
