#ifndef QRK_CHAT_MESSAGE_H
#define QRK_CHAT_MESSAGE_H

/*!
  \file
  \brief チャット等のメッセージ表示用

  追加したメッセージの行毎の表示と、フェードアウトしながら表示を消すことができる。

  \author Satofumi KAMIMURA

  $Id: ChatMessage.h 857 2009-05-11 12:59:05Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
  class Font;

  /*!
    \brief チャット等のメッセージ表示用
  */
  class ChatMessage : public Component
  {
    ChatMessage(const ChatMessage& rhs);
    ChatMessage& operator = (ChatMessage& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit ChatMessage(Font& font, const Rect<long>& rect);
    ~ChatMessage(void);

    Rect<long> rect(void) const;
    void setEventAcceptable(bool acceptable);
    void setAlpha(float alpha);
    void draw(const Rect<long>& area);

    void setDrawTimeout(size_t msec);
    void setFadeoutTime(size_t msec);
    void setOffset(const Point<long>& offset);

    void clear(void);
    void print(const char text[]);
    void newline(void);
  };
}

#endif /* !QRK_CHAT_MESSAGE_H */
