#ifndef QRK_ALIGN_UTILS_H
#define QRK_ALIGN_UTILS_H

/*!
  \file
  \brief 位置揃え用の関数

  \author Satofumi KAMIMURA

  $Id: AlignUtils.h 897 2009-05-17 20:59:55Z satofumi $
*/

namespace qrk
{
  class Component;
  class Surface;


  long left(const Component& component, long x);
  long center(const Component& component, long x);
  long right(const Component& component, long x);

  long top(const Component& component, long y);
  long middle(const Component& component, long y);
  long bottom(const Component& component, long y);

  long left(const Surface& component, long x);
  long center(const Surface& component, long x);
  long right(const Surface& component, long x);

  long top(const Surface& component, long y);
  long middle(const Surface& component, long y);
  long bottom(const Surface& component, long y);
};

#endif /* !QRK_ALIGN_UTILS_H */
