#ifndef QRK_NMEA_DATA_H
#define QRK_NMEA_DATA_H

/*!
  \file
  \brief NMEA 形式のデータ

  \author Satofumi KAMIMURA

  $Id: NmeaData.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "Position.h"
#include <string>


namespace qrk
{
  /*!
    \brief NMEA 形式のデータ
  */
  class NmeaData
  {
    Angle origin_latitude_;
    Angle origin_longitude_;
    double origin_altitude_;

  public:
    unsigned char hour;
    unsigned char minute;
    unsigned char sec;
    unsigned char msec;

    Angle latitude;             //!< 緯度
    Angle longitude;            //!< 経度
    double altitude;            //!< 海抜 [m]

    size_t satellites;          //!< 衛星数


    NmeaData(void)
      : origin_altitude_(0), hour(0), minute(0), sec(0), msec(0)
    {
    }


    void setLine(const std::string& line);

    bool validPosition(void);
    void setOrigin(const Angle& lat, const Angle& lng, double alt = 0.0);
    Position<long> position(const Angle& lat, const Angle& lng,
                            double alt = 0.0);
  };
}

#endif /* !QRK_NMEA_DATA_H */
