#ifndef QRK_GPS_CTRL_H
#define QRK_GPS_CTRL_H

/*!
  \file
  \brief GPS モジュール

  \author Satofumi KAMIMURA

  $Id: GpsCtrl.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "Gps.h"
#include <memory>


namespace qrk
{
  /*!
    \brief GPS モジュール
  */
  class GpsCtrl : public Gps
  {
    GpsCtrl(const GpsCtrl& rhs);
    GpsCtrl& operator = (const GpsCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200,
    };

    GpsCtrl(void);
    ~GpsCtrl(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void);

    void update(NmeaData* nmea);
  };
}

#endif /* !QRK_GPS_CTRL_H */
