#ifndef QRK_GPS_H
#define QRK_GPS_H

/*!
  \file
  \brief GPS モジュールインターフェース

  \author Satofumi KAMIMURA

  $Id: Gps.h 783 2009-05-05 08:56:26Z satofumi $
*/


namespace qrk
{
  class Connection;
  class NmeaData;


  /*!
    \brief GPS モジュールインターフェース
  */
  class Gps
  {
  public:
    virtual ~Gps(void) {}

    virtual const char* what(void) const = 0;

    virtual bool connect(const char* device, long baudrate) = 0;
    virtual void setConnection(Connection* con) = 0;
    virtual Connection* connection(void) = 0;
    virtual void disconnect(void) = 0;
    virtual bool isConnected(void) = 0;

    virtual void update(NmeaData* nmea) = 0;
  };
}

#endif /* !QRK_GPS.H */
