#ifndef QRK_RECT_H
#define QRK_RECT_H

/*!
  \file
  \brief 矩形の型定義

  \author Satofumi KAMIMURA

  $Id: Rect.h 883 2009-05-13 19:32:54Z satofumi $
*/

namespace qrk
{
  /*!
    \brief 矩形の型定義
  */
  template <typename T>
  class Rect
  {
  public:
    T x;
    T y;
    T w;
    T h;


    Rect(void) : x(0), y(0), w(0), h(0)
    {
    }


    Rect(T x_, T y_, T w_, T h_) : x(x_), y(y_), w(w_), h(h_)
    {
    }


    bool operator < (const Rect<T>& rhs) const
    {
      if (y < rhs.y) {
        return true;

      } else if (x < rhs.x) {
        return true;

      } else {
        return false;
      }
    }
  };
}

#endif /* !QRK_RECT_H */
