#ifndef QRK_COORDINATE_H
#define QRK_COORDINATE_H

/*!
  \file
  \brief 座標系の制御

  \author Satofumi KAMIMURA

  $Id: Coordinate.h 783 2009-05-05 08:56:26Z satofumi $

  \todo 位置を更新するためのメソッドを追加する
*/

#include "Position.h"
#include <vector>
#include <memory>


namespace qrk
{

  /*!
    \brief 座標系の制御
  */
  class Coordinate
  {
    Coordinate(const Coordinate& rhs);
    Coordinate& operator = (const Coordinate& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  protected:
    void updatePointPosition(Position<long>& position,
                             const Position<long>& offset,
                             bool invert = false) const;

  public:
    Coordinate(void);

    //! parent が NULL のとき、offset 指定は無視される
    Coordinate(Coordinate* parent, const qrk::Position<long>& offset);
    virtual ~Coordinate(void);

    Coordinate* parent(void);
    const std::vector<Coordinate*> children(void);

    void addChild(Coordinate* child);
    void addChild(Coordinate* child, const qrk::Position<long>& offset);
    void addChildToModule(Coordinate* child);
    void addChildToModule(Coordinate* child, const qrk::Position<long>& offset);

    // 指定された子座標系の原点位置を、自座標系のどこに配置しているかを返す
    qrk::Position<long> offset(const Coordinate* child) const;

    /*!
      \brief 位置

      指定した座標系における位置を返す

      \param[in] coordinate 座標系

      \return 位置
    */
    virtual qrk::Position<long> position(Coordinate* coordinate = NULL)
    {
      return originPosition(coordinate);
    }

    //! 自オブジェクトの原点が、指定座標系のどこにあるのかを返す
    qrk::Position<long> originPosition(Coordinate* coordinate = NULL);

    //! 自オブジェクトの指定点が、指定座標系のどこにあるのかを返す
    qrk::Position<long> pointPosition(Coordinate* coordinate,
                                      const qrk::Position<long>& position);
  };
}

#endif /* !QRK_COORDINATE_H */
